package gov.va.med.mhv.mrp.service.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.data.model.MyGoals;

@Component
public class MyGoalListConverter implements Converter<List<MyGoals>, List<MyGoalDTO>> {

	@Autowired
	private MyGoalConverter myGoalConverter;

	@Override
	public List<MyGoalDTO> convert(List<MyGoals> mygoals) {
		List<MyGoalDTO> dtos = new ArrayList<MyGoalDTO>();
		for (MyGoals mygoal : mygoals) {
			MyGoalDTO dto = myGoalConverter.convert(mygoal);
			dtos.add(dto);
		}
		return dtos;
	}	

}
